-------------------------------------------------------------------------------------------------------------------
-- REVISION 9 LUA Scripts (Ov3rHell3XoduZ)
-- Theme Metrics moved to LUA for METRO QUAD X
-------------------------------------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------------------------------------
-- [ScreenGameplay] SurroundLife Position.
-------------------------------------------------------------------------------------------------------------------
function SurroundLifeP1X()
	local Style = GAMESTATE:GetCurrentStyle():GetStyleType()
	local sName = GAMESTATE:GetCurrentStyle():GetName()
	local Techno = GAMESTATE:GetCurrentGame():GetName() == "techno"
	local pos
	
	if Techno or sName == "solo" or Style == 'StyleType_OnePlayerTwoSides' then
		pos = CenterX()
	elseif Style == 'StyleType_OnePlayerOneSide' or Style == 'StyleType_TwoPlayersTwoSides' then
		pos = Left()
	end
	return pos
end

function SurroundLifeP2X()
	local Style = GAMESTATE:GetCurrentStyle():GetStyleType()
	local sName = GAMESTATE:GetCurrentStyle():GetName()
	local Techno = GAMESTATE:GetCurrentGame():GetName() == "techno"
	local pos
	
	if Techno or sName == "solo" or Style == 'StyleType_OnePlayerTwoSides' then
		pos = CenterX()
	elseif Style == 'StyleType_OnePlayerOneSide' or Style == 'StyleType_TwoPlayersTwoSides' then
		pos = Right()
	end
	return pos
end

-------------------------------------------------------------------------------------------------------------------
-- [ScreenGameplay] PlayerOptions.
-------------------------------------------------------------------------------------------------------------------
function PlayerOptionsX(pn)
	local Style = GAMESTATE:GetCurrentStyle():GetName()
	
	if pn == PLAYER_1 then
		if Style == "single" then return CenterX()-30
		elseif Style == "double" then return CenterX()
		elseif Style == "solo" then return CenterX()
		elseif Style == "versus" then return PlayFieldPosition(PLAYER_1)
		elseif Style == "single8" then return PlayFieldPositionForCenterElements(PLAYER_1)
		elseif Style == "double8" then return CenterX()
		end
	end
	if pn == PLAYER_2 then
		if Style == "single" then return CenterX()+30
		elseif Style == "double" then return CenterX()
		elseif Style == "solo" then return CenterX()
		elseif Style == "versus" then return PlayFieldPosition(PLAYER_2)
		elseif Style == "single8" then return PlayFieldPositionForCenterElements(PLAYER_2)
		elseif Style == "double8" then return CenterX()
		end
	end
end

function PlayerOptionsP1OnCommand(self)
	local Style = GAMESTATE:GetCurrentStyle():GetName()
	
	if Style == "single" then self:draworder(100):zoom(0.4):halign(0):maxwidth(1128)
	elseif Style == "double" then self:draworder(100):zoom(0.4):maxwidth(1586)
	elseif Style == "solo" then self:draworder(100):zoom(0.4):maxwidth(1586)
	elseif Style == "versus" then self:draworder(100):zoom(0.4):maxwidth(840)
	end
end

function PlayerOptionsP2OnCommand(self)
	local Style = GAMESTATE:GetCurrentStyle():GetName()
	
	if Style == "single" then self:draworder(100):zoom(0.4):halign(1):maxwidth(1128)
	elseif Style == "double" then self:draworder(100):zoom(0.4):maxwidth(1586)
	elseif Style == "solo" then self:draworder(100):zoom(0.4):maxwidth(1586)
	elseif Style == "versus" then self:draworder(100):zoom(0.4):maxwidth(840)
	end
end

-------------------------------------------------------------------------------------------------------------------
-- SCREEN NET ROOM BASE (Users).
-------------------------------------------------------------------------------------------------------------------
NetUsers = { Position = { X = CenterX()-172, Y = CenterY()+172 }, }

function NetUsersX() return NetUsers.Position["X"] end
function NetUsersY() return NetUsers.Position["Y"] end
function UserSpacingX() local Pos = 64 return Pos end
function UserSpacingY() local Pos = 16 return Pos end